#include <struct.h>

#include "FloatBar.h"
#include "TreeView.h"
#include "LinkedList.h"
#include "resource.h"

BEGIN_MESSAGE_MAP(CHierarchyBar, CDialog)
  ON_WM_SIZE()
  ON_NOTIFY(TVN_BEGINDRAG, TREE_VIEW_ID, BeginDrag)
END_MESSAGE_MAP()


CHierarchyBar::~CHierarchyBar()
{
}


BOOL CHierarchyBar::OnInitDialog()
{
  //create a tree-view control
  RECT rect;
  GetClientRect(&rect);
  pTree = new CHView();
  pTree->Create(NULL, NULL,
    WS_CHILD | WS_VISIBLE | 
    TVS_HASLINES | TVS_HASBUTTONS | TVS_LINESATROOT, rect, this, TREE_VIEW_ID);


  pTree->ReloadFromList();

  return TRUE;
}


void CHierarchyBar::OnSize(UINT nType, int cx, int cy)
{
  CDialog::OnSize(nType, cx, cy);
  if (nType!=SIZE_RESTORED)
    return;
  if (pTree)
    pTree->SetWindowPos(this, 0,0,cx,cy,SWP_NOZORDER | SWP_SHOWWINDOW);
}


afx_msg void CHierarchyBar::BeginDrag( NMHDR * pNotifyStruct, LRESULT * result)
{
  pTree->BeginDrag();
  *result = 0;
}
